## TFSA-2021-196: Overflow/crash in `tf.tile` when tiling tensor is large

### CVE Number
CVE-2021-41198

### Impact
If `tf.tile` is called with a large input argument then the TensorFlow process will crash due to a `CHECK`-failure caused by an overflow.

```python
import tensorflow as tf
import numpy as np
tf.keras.backend.tile(x=np.ones((1,1,1)), n=[100000000,100000000, 100000000])
```

The number of elements in the output tensor is too much for the `int64_t` type and the overflow is detected via a `CHECK` statement. This aborts the process.

### Patches
We have patched the issue in GitHub commit [9294094df6fea79271778eb7e7ae1bad8b5ef98f](https://github.com/tensorflow/tensorflow/commit/9294094df6fea79271778eb7e7ae1bad8b5ef98f) (merging [#51138](https://github.com/tensorflow/tensorflow/pull/51138)).

The fix will be included in TensorFlow 2.7.0. We will also cherrypick this commit on TensorFlow 2.6.1, TensorFlow 2.5.2, and TensorFlow 2.4.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported externally via a [GitHub issue](https://github.com/tensorflow/tensorflow/issues/46911).
