---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, tableau, tableaux,
              alignement, aligner sur la virgule, aligner sur le point, 
              aligner des nombres, séparateur décimal
---

# Comment aligner des nombres sur le séparateur décimal ?

## Avec un tableau

Vous pouvez tout d'abord *tricher* en utilisant un tableau où une virgule sert
de séparateur de colonnes. Voici un exemple de cette méthode
en mode mathématique avec l'environnement `array` :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\[
  \begin{array}{|r @{,} l|}
    1 & 2    \\
    233 & 45 \\
    x & y    \\
  \end{array}
\]
\end{document}
```


## Avec l'extension <ctanpkg:dcolumn>

L'extension <ctanpkg:dcolumn>, de David Carlisle, permet d'aligner les nombres
d'un tableau par rapport à leur séparateur décimal. Elle met à cet effet 
un type de colonne `D` à trois paramètres :

```{noedit}
D{⟨séparateur du code⟩}{⟨séparateur affiché⟩}{⟨nombre de décimales⟩}
```

Ces paramètres sont :
- le `⟨séparateur du code⟩` LaTeX comme le `⟨séparateur affiché⟩` 
  dans le document final permettent de gérer les variantes linguistiques 
  que sont la virgule, le point ou tout autre symbole vous semblant utile ;
- le `⟨nombre de décimales⟩` permet de bien définir l'espace qu'occupe 
  le nombre : des nombres avec plus de décimales iront donc déborder 
  dans les autres colonnes.

Voici un exemple avec l'environnement `array` (que nous pourrions faire aussi 
avec l'environnement `tabular`) pour du français avec deux décimales, en créant
au passage notre propre type de colonne basé sur D avec `\newcolumntype` :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{dcolumn}

  \newcolumntype{,}{D{,}{,}{2}} % Notre style de colonne "," basé sur "D"

\begin{document}
\[
  \begin{array}{|,|}
    1,2    \\
    233,45 \\
    x,y    \\ 
    10
  \end{array}
\]
\end{document}
```


## Avec l'extension <ctanpkg:siunitx>

Toujours dans un tableau, en dehors du mode mathématique, 
l'extension <ctanpkg:siunitx>, de Joseph Wright, met à disposition le style 
de colonne `S`, aligné sur le marqueur décimal mais aussi les milliers 
(espace en français, virgule en anglais), comme le montre l'exemple suivant.

```
\documentclass{article}
  \usepackage[T1]{fontenc}         % Encodage T1 (adapté au français)
  \usepackage{lmodern}             % Caractères plus lisibles
  \pagestyle{empty}                % N'affiche pas de numéro de page
  \usepackage[locale=FR]{siunitx}  % Pour du français

\begin{document}
\begin{tabular}{lS}
  A & 1,23          \\
  B & 123456,123456 \\
\end{tabular}
\end{document}
```


## Avec l'extension <ctanpkg:numprint>

L'extension <ctanpkg:numprint>, d'Harald Harders, fournit des types 
de colonnes `n` et `N` qui permettent d'aligner les valeurs 
sur le séparateur décimal (le premier pour un tableau mathématique, le second
pour un tableau textuel). Ces types de colonne ont le format suivant :

```{noedit}
n{⟨nombre de chiffre avant la virgule⟩}{⟨nombre de chiffre après la virgule⟩}
```

En voici un exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{numprint}

\begin{document}
\[
  \begin{array}{|n{3}{2}|}
    1,2    \\
    233,45 \\
    %x,y   \\ % Restituerait "x  0,0 y" sinon
    10
  \end{array}
\]
\end{document}
```